/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.mods.autocomplete.config;

import club.sk1er.mods.autocomplete.HypixelRank;
import club.sk1er.mods.autocomplete.JsonHolder;
import club.sk1er.mods.autocomplete.config.AutocompleteConfig;
import java.util.EnumMap;

public class FriendsConfig
extends AutocompleteConfig {
    private EnumMap<HypixelRank, Boolean> states = new EnumMap(HypixelRank.class);

    public boolean get(HypixelRank rank) {
        return this.states.getOrDefault((Object)rank, true);
    }

    @Override
    public void load(JsonHolder data) {
        super.load(data);
        JsonHolder ranks = data.optJsonObject("ranks");
        for (String key : ranks.getKeys()) {
            this.states.put(HypixelRank.parse(key), ranks.optBoolean(key));
        }
    }

    @Override
    public void save(JsonHolder data) {
        super.save(data);
        JsonHolder jsonHolder = new JsonHolder();
        for (HypixelRank hypixelRank : this.states.keySet()) {
            jsonHolder.put(hypixelRank.toString(), this.states.get((Object)hypixelRank));
        }
        data.put("ranks", jsonHolder);
    }

    public void toggle(HypixelRank value) {
        this.states.put(value, !this.get(value));
    }
}

